/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FMLServiceProvider
implements ITransformationService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private ArgumentAcceptingOptionSpec<String> modsOption;
    private ArgumentAcceptingOptionSpec<String> modListsOption;
    private ArgumentAcceptingOptionSpec<String> mavenRootsOption;
    private ArgumentAcceptingOptionSpec<String> fmlOption;
    private ArgumentAcceptingOptionSpec<String> forgeOption;
    private ArgumentAcceptingOptionSpec<String> mcOption;
    private ArgumentAcceptingOptionSpec<String> mcpOption;
    private ArgumentAcceptingOptionSpec<String> mappingsOption;
    private List<String> modsArgumentList;
    private List<String> modListsArgumentList;
    private List<String> mavenRootsArgumentList;
    private String targetForgeVersion;
    private String targetFMLVersion;
    private String targetMcVersion;
    private String targetMcpVersion;
    private String targetMcpMappings;
    private Map<String, Object> arguments;

    public FMLServiceProvider() {
        String markerselection = System.getProperty("forge.logging.markers", "");
        Arrays.stream(markerselection.split(",")).forEach(marker -> System.setProperty("forge.logging.marker." + marker.toLowerCase(Locale.ROOT), "ACCEPT"));
    }

    public String name() {
        return "fml";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Setting up basic FML game directories");
        FMLPaths.setup(environment);
        LOGGER.debug(LogMarkers.CORE, "Loading configuration");
        FMLConfig.load();
        LOGGER.debug(LogMarkers.CORE, "Preparing ModFile");
        environment.computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODFILEFACTORY.get(), k -> ModFile::new);
        this.arguments = new HashMap<String, Object>();
        this.arguments.put("modLists", this.modListsArgumentList);
        this.arguments.put("mods", this.modsArgumentList);
        this.arguments.put("mavenRoots", this.mavenRootsArgumentList);
        this.arguments.put("forgeVersion", this.targetForgeVersion);
        this.arguments.put("fmlVersion", this.targetFMLVersion);
        this.arguments.put("mcVersion", this.targetMcVersion);
        this.arguments.put("mcpVersion", this.targetMcpVersion);
        this.arguments.put("mcpMappings", this.targetMcpMappings);
        LOGGER.debug(LogMarkers.CORE, "Preparing launch handler");
        FMLLoader.setupLaunchHandler(environment, this.arguments);
        FMLEnvironment.setupInteropEnvironment(environment);
        Environment.build((IEnvironment)environment);
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Initiating mod scan");
        return FMLLoader.beginModScan(this.arguments);
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        return FMLLoader.completeScan(layerManager);
    }

    public void onLoad(IEnvironment environment, Set<String> otherServices) throws IncompatibleEnvironmentException {
        FMLLoader.onInitialLoad(environment, otherServices);
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.forgeOption = argumentBuilder.apply("forgeVersion", "Forge Version number").withRequiredArg().ofType(String.class).required();
        this.fmlOption = argumentBuilder.apply("fmlVersion", "FML Version number").withRequiredArg().ofType(String.class).required();
        this.mcOption = argumentBuilder.apply("mcVersion", "Minecraft Version number").withRequiredArg().ofType(String.class).required();
        this.mcpOption = argumentBuilder.apply("mcpVersion", "MCP Version number").withRequiredArg().ofType(String.class).required();
        this.mappingsOption = argumentBuilder.apply("mcpMappings", "MCP Mappings Channel and Version").withRequiredArg().ofType(String.class);
        this.modsOption = argumentBuilder.apply("mods", "List of mods to add").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.modListsOption = argumentBuilder.apply("modLists", "JSON modlists").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
        this.mavenRootsOption = argumentBuilder.apply("mavenRoots", "Maven root directories").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",");
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        this.modsArgumentList = option.values(this.modsOption);
        this.modListsArgumentList = option.values(this.modListsOption);
        this.mavenRootsArgumentList = option.values(this.mavenRootsOption);
        this.targetFMLVersion = (String)option.value(this.fmlOption);
        this.targetForgeVersion = (String)option.value(this.forgeOption);
        this.targetMcVersion = (String)option.value(this.mcOption);
        this.targetMcpVersion = (String)option.value(this.mcpOption);
        this.targetMcpMappings = (String)option.value(this.mappingsOption);
    }

    @NotNull
    public List<ITransformer> transformers() {
        LOGGER.debug(LogMarkers.CORE, "Loading coremod transformers");
        return new ArrayList<ITransformer>(FMLLoader.getCoreModProvider().getCoreModTransformers());
    }
}

