/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fml.loading.targets.ArgumentList;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonDevLaunchHandler
extends CommonLaunchHandler {
    @Override
    public String getNaming() {
        return "mcp";
    }

    @Override
    public boolean isProduction() {
        return false;
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        Stream.Builder<Path> mcstream = Stream.builder();
        String[] legacyCP = this.getLegacyClasspath();
        Path extra = CommonDevLaunchHandler.findJarOnClasspath(legacyCP, "client-extra");
        Stream.Builder<List<Path>> modstream = Stream.builder();
        Map<String, List<Path>> mods = this.getModClasses();
        List<Path> minecraft = mods.remove("minecraft");
        if (minecraft == null) {
            throw new IllegalStateException("Could not find 'minecraft' mod paths.");
        }
        minecraft.stream().distinct().forEach(mcstream::add);
        mods.values().forEach(modstream::add);
        mcstream.add(extra);
        BiPredicate<String, String> mcFilter = this.getMcFilter(extra, minecraft, modstream);
        return new CommonLaunchHandler.LocatedPaths(mcstream.build().toList(), mcFilter, modstream.build().toList(), this.getFmlPaths(legacyCP));
    }

    @Override
    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        super.preLaunch(arguments, layer);
        if (this.getDist().isDedicatedServer()) {
            return arguments;
        }
        if (this.isData()) {
            return arguments;
        }
        ArgumentList args = ArgumentList.from(arguments);
        String username = args.get("username");
        if (username != null) {
            Matcher m = Pattern.compile("#+").matcher(username);
            StringBuffer replaced = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(replaced, CommonDevLaunchHandler.getRandomNumbers(m.group().length()));
            }
            m.appendTail(replaced);
            args.put("username", replaced.toString());
        } else {
            args.putLazy("username", "Dev");
        }
        if (!args.hasValue("accessToken")) {
            args.put("accessToken", "0");
        }
        return args.getArguments();
    }

    protected static Optional<Path> searchJarOnClasspath(String[] classpath, String match) {
        return Arrays.stream(classpath).filter(e -> FileUtils.matchFileName(e, false, match)).findFirst().map(x$0 -> Paths.get(x$0, new String[0]));
    }

    protected static Path findJarOnClasspath(String[] classpath, String match) {
        return CommonDevLaunchHandler.searchJarOnClasspath(classpath, match).orElseThrow(() -> new IllegalStateException("Could not find " + match + " in classpath"));
    }

    protected BiPredicate<String, String> getMcFilter(Path extra, List<Path> minecraft, Stream.Builder<List<Path>> mods) {
        String[] packages = this.getPackages();
        String extraPath = extra.toString().replace('\\', '/');
        BiPredicate<String, String> mcFilter = (path, base) -> {
            if (base.equals(extraPath) || path.endsWith("/")) {
                return true;
            }
            for (String pkg : packages) {
                if (!path.startsWith(pkg)) continue;
                return false;
            }
            return true;
        };
        SecureJar modJar = SecureJar.from((path, base) -> {
            if (!path.endsWith(".class")) {
                return true;
            }
            for (String pkg : packages) {
                if (!path.startsWith(pkg)) continue;
                return true;
            }
            return false;
        }, (Path[])((Path[])minecraft.stream().distinct().toArray(Path[]::new)));
        mods.add(List.of(modJar.getRootPath()));
        return mcFilter;
    }

    protected String[] getPackages() {
        return new String[]{"net/minecraftforge/", "META-INF/services/", "META-INF/coremods.json", "META-INF/mods.toml"};
    }

    private static String getRandomNumbers(int length) {
        return Long.toString(System.nanoTime() % (long)((int)Math.pow(10.0, length)));
    }
}

